/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.system;

import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.xml.ClassConfigData;
import com.ibm.hwmca.xfw.pa.system.RemoteSystem;
import com.ibm.hwmca.xfw.pa.system.RemoteSystemStateEvent;
import com.ibm.hwmca.xfw.pa.system.RemoteSystemStateListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class RemoteSystemProvider {
    private static final String TRACE_MASKT = "XPARSP T";
    private static final String TRACE_MASKF = "XPARSP F";
    private static final String TRACE_MASKD = "XPARSP D";
    protected ClassConfigData ccData = null;
    protected Map systemMap = new HashMap();
    protected boolean providerInitialized = false;
    protected Set rsStateListenerSet = new HashSet();

    public RemoteSystemProvider(ClassConfigData ccData) {
        Trace.trace(TRACE_MASKD, "<-> ctor");
        this.ccData = ccData;
        this.initializeTrackedSystems();
        this.providerInitialized = true;
    }

    protected abstract void initializeTrackedSystems();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getTrackedSystems() {
        HashSet cloneSet = new HashSet();
        Map map = this.systemMap;
        synchronized (map) {
            Set keys = this.systemMap.keySet();
            Iterator keyIter = keys.iterator();
            while (keyIter.hasNext()) {
                cloneSet.add(this.systemMap.get(keyIter.next()));
            }
        }
        return cloneSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRemoteSystem(Object systemKey, RemoteSystem system) {
        Trace.trace(TRACE_MASKD, "<-> addRemoteSystem:" + systemKey);
        Map map = this.systemMap;
        synchronized (map) {
            this.systemMap.put(systemKey, system);
        }
    }

    protected void addRemoteSystem(Object systemKey, RemoteSystem system, boolean fireNotice) {
        this.addRemoteSystem(systemKey, system);
        if (fireNotice) {
            this.fireRemoteSystemStateChanged(new RemoteSystemStateEvent("Add", system));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeRemoteSystem(Object systemKey, RemoteSystem system) {
        Trace.trace(TRACE_MASKD, "<-> changeRemoteSystem:" + systemKey);
        Map map = this.systemMap;
        synchronized (map) {
            this.systemMap.put(systemKey, system);
        }
    }

    protected void changeRemoteSystem(Object systemKey, RemoteSystem system, boolean fireNotice) {
        this.changeRemoteSystem(systemKey, system);
        if (fireNotice) {
            this.fireRemoteSystemStateChanged(new RemoteSystemStateEvent("Change", system));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemoteSystem removeRemoteSystem(Object systemKey) {
        Map map = this.systemMap;
        synchronized (map) {
            return (RemoteSystem)this.systemMap.remove(systemKey);
        }
    }

    protected void removeRemoteSystem(Object systemKey, boolean fireNotice) {
        RemoteSystem system = this.removeRemoteSystem(systemKey);
        if (system != null && fireNotice) {
            this.fireRemoteSystemStateChanged(new RemoteSystemStateEvent("Remove", system));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteSystemStateListener(RemoteSystemStateListener rsStateListener) {
        Set set = this.rsStateListenerSet;
        synchronized (set) {
            this.rsStateListenerSet.add(rsStateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemoteSystemStateListener(RemoteSystemStateListener rsStateListener) {
        Set set = this.rsStateListenerSet;
        synchronized (set) {
            this.rsStateListenerSet.remove(rsStateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRemoteSystemStateChanged(RemoteSystemStateEvent rsStateEvent) {
        Trace.trace(TRACE_MASKD, "--> fireRemoteSystemStateChanged");
        Trace.trace(TRACE_MASKD, "firing: " + rsStateEvent);
        Set set = this.rsStateListenerSet;
        synchronized (set) {
            Iterator listenerIter = this.rsStateListenerSet.iterator();
            while (listenerIter.hasNext()) {
                ((RemoteSystemStateListener)listenerIter.next()).remoteSystemStateChanged(rsStateEvent);
            }
        }
        Trace.trace(TRACE_MASKD, "<-- fireRemoteSystemStateChanged");
    }
}

